/*
 * Decompiled with CFR 0.152.
 */
package com.flightpanels.scs;

import com.flightpanels.scs.ConnectedClient;
import com.flightpanels.scs.IBusConnector;
import com.flightpanels.scs.ICanAeroDataManager;
import com.flightpanels.scs.INetworkConnector;
import com.flightpanels.scs.can_t;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanAeroBusConnector
implements IBusConnector<can_t> {
    private ConcurrentHashMap<Short, ConnectedClient> m_connected_clients;
    private short m_own_node_id;
    private short m_config_revision;
    private long m_gen_uuid;
    private ICanAeroDataManager m_manager;
    private INetworkConnector<can_t> m_network_connector;

    public CanAeroBusConnector(ICanAeroDataManager manager, INetworkConnector<can_t> connector, short own_node_id, short config_revision) {
        this.m_manager = manager;
        this.m_network_connector = connector;
        this.m_config_revision = config_revision;
        if (own_node_id == 255) {
            Random r = new Random();
            this.m_gen_uuid = r.nextInt(Integer.MAX_VALUE);
            this.m_own_node_id = (short)255;
        } else {
            this.m_gen_uuid = 0L;
            this.m_own_node_id = own_node_id;
            this.sendIDS((short)0);
        }
        this.m_connected_clients = new ConcurrentHashMap();
        connector.setListener(this);
    }

    void doHouseKeeping() {
        if (this.m_own_node_id == 255) {
            can_t req_node_id = can_t.writeNCSNodeServiceRequest(this.m_gen_uuid, 128L);
            this.send(req_node_id);
        }
        Set keyset = this.m_connected_clients.keySet();
        for (Short key : keyset) {
            if (this.m_connected_clients.get(key).hasTimedOut() && this.m_connected_clients.get(key).wasPoked()) {
                if (this.m_connected_clients.get(key).nodeId() == 1) {
                    System.out.println("Lost connection with SCS, resetting into uninitialized state.");
                    this.m_own_node_id = (short)255;
                }
                this.m_connected_clients.remove(key);
                continue;
            }
            if (!this.m_connected_clients.get(key).hasTimedOut()) continue;
            this.sendIDS(this.m_connected_clients.get(key).nodeId());
            this.m_connected_clients.get(key).poke();
        }
    }

    public short ownNodeId() {
        return this.m_own_node_id;
    }

    @Override
    public void send(can_t msg) {
        this.m_network_connector.send(msg);
    }

    @Override
    public void send(Vector<can_t> msg) {
        throw new RuntimeException("Writing of vectors not implemented yet");
    }

    public void sendSTS(short node_id) {
        byte[] buf = new byte[4];
        can_t request = can_t.writeNodeServiceRequest(node_id, (short)7, (short)0, buf, this.m_own_node_id, 128L);
        this.send(request);
    }

    public void sendMCS(short node_id, int module, int mode) {
        can_t request = can_t.writeMCSNodeServiceRequest(node_id, module, mode, this.m_own_node_id, 128L);
        this.send(request);
    }

    public void sendDRS(long request_id, boolean id29, short node_id) {
        long id = id29 ? request_id | Integer.MIN_VALUE : request_id & Integer.MAX_VALUE;
        can_t request = can_t.writeDRSNodeServiceRequest((short)0, id, node_id, 128L);
        this.send(request);
    }

    public void sendIDS(short node_id) {
        can_t request = can_t.writeIDSNodeServiceRequest(node_id, this.m_own_node_id, 128L);
        this.send(request);
    }

    @Override
    public void receiveMessage(can_t message) {
        long id = message.id;
        if ((id & Integer.MAX_VALUE) == 128L) {
            if ((message.node_id == 0 || message.node_id == this.m_own_node_id) && message.message_code != this.m_own_node_id) {
                this.processServiceRequests(message);
            }
            return;
        }
        if ((id & Integer.MAX_VALUE) == 129L) {
            if (message.node_id != this.m_own_node_id) {
                this.processServiceResponses(message);
            }
            return;
        }
        if ((id & Integer.MAX_VALUE) > 300L && (id & Integer.MAX_VALUE) < 1900L) {
            if (message.node_id == this.m_own_node_id) {
                return;
            }
            this.m_manager.incomingData(message);
            ConnectedClient it = this.m_connected_clients.get(message.node_id);
            if (it != null) {
                it.resetTimer();
            }
        } else {
            System.err.println("Received CAN ID " + (id & Integer.MAX_VALUE) + ", not a supported ID. See SCS standards addendum document.");
        }
    }

    @Override
    public void receiveMessage(Vector<can_t> msg) {
        for (can_t can : msg) {
            this.receiveMessage(can);
        }
    }

    private void processServiceRequests(can_t message) {
        switch (message.service_code) {
            case 0: {
                if (this.m_own_node_id != 255) {
                    short requestor_node_id = message.message_code;
                    System.out.println("Got IDS from node " + requestor_node_id);
                    byte[] buf = new byte[]{1, (byte)this.m_config_revision, 100, 0};
                    can_t response = can_t.writeNodeServiceResponse(this.m_own_node_id, (short)0, (short)16, buf, requestor_node_id, 129L);
                    this.send(response);
                    ConnectedClient it = this.m_connected_clients.get(requestor_node_id);
                    if (it == null) {
                        System.out.println("Node " + requestor_node_id + " is unknown, IDS sent");
                        this.sendIDS(requestor_node_id);
                        break;
                    }
                    System.out.println("Node " + requestor_node_id + " is known, its timer was reset.");
                    it.resetTimer();
                    break;
                }
                this.doHouseKeeping();
                break;
            }
            case 7: {
                this.m_manager.handleSTS();
                break;
            }
            case 100: {
                short requestor_node_id = message.message_code;
                ConnectedClient it = this.m_connected_clients.get(requestor_node_id);
                if (it != null) {
                    it.resetTimer();
                    long requested_id = message.getUnsignedIntFromCan();
                    System.out.println("Will handle DRS " + (requested_id & Integer.MAX_VALUE));
                    this.m_manager.handleDRS(requested_id);
                    break;
                }
                System.out.println("Node " + requestor_node_id + " is unknown, IDS sent.");
                this.sendIDS(requestor_node_id);
                break;
            }
            case 12: 
            case 13: {
                short requestor_node_id = message.message_code;
                ConnectedClient it = this.m_connected_clients.get(requestor_node_id);
                if (it == null) {
                    System.out.println("Received MCS from unknown client.");
                    break;
                }
                if (message.service_code == 13) {
                    this.m_manager.handleMCS(message.getFirstUnsignedShortFromCan(), message.getSecondUnsignedShortFromCan());
                    break;
                }
                this.m_manager.handleMIS();
                break;
            }
            case 102: {
                if (message.getUnsignedIntFromCan() == this.m_gen_uuid) break;
                System.out.println("DEBUG: Someone asked for an NCS, I won't answer. SCS must do this.");
                break;
            }
            default: {
                System.err.println("Unknown Node Service Request with service code " + message.service_code);
            }
        }
    }

    private void processServiceResponses(can_t message) {
        switch (message.service_code) {
            case 0: {
                short client_node_id = message.node_id;
                short client_hardware_revision = message.getUCharFromCan((short)0);
                short client_software_revision = message.getUCharFromCan((short)1);
                short client_identifier_distribution = message.getUCharFromCan((short)2);
                short client_header_type = message.getUCharFromCan((short)3);
                if (client_header_type == 0 && client_identifier_distribution == 100) {
                    if (client_node_id == 1 && this.m_config_revision > client_software_revision) {
                        throw new RuntimeException("This application requires SCS with minimum config revision " + this.m_config_revision + ", but your SCS has only " + client_software_revision + ". You must update SCS to run this application.");
                    }
                    ConnectedClient client = new ConnectedClient(client_node_id, client_hardware_revision, client_software_revision, client_identifier_distribution, client_header_type);
                    ConnectedClient it = this.m_connected_clients.get(client_node_id);
                    if (it != null) {
                        it.resetTimer();
                        break;
                    }
                    System.out.println("Node " + client_node_id + " with hardware rev " + client_hardware_revision + ", software rev " + client_software_revision + " added to list of known clients.");
                    this.m_connected_clients.put(client_node_id, client);
                    break;
                }
                System.err.println("Node " + message.node_id + " has unacceptable id distribution or header type and was refused.");
                break;
            }
            case 102: {
                short my_new_node_id;
                long uuid = message.getUnsignedIntFromCan();
                if (uuid != this.m_gen_uuid) break;
                this.m_own_node_id = my_new_node_id = message.message_code;
                this.sendIDS((short)0);
                break;
            }
            default: {
                System.out.println("Unknown Node Service Response with service code " + message.service_code + " from node " + message.node_id);
            }
        }
    }
}

