/*
 * Decompiled with CFR 0.152.
 */
package com.flightpanels.scs;

import com.flightpanels.scs.AS_IDwidth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanAeroMetadata
implements Comparable<CanAeroMetadata> {
    private short m_node_id;
    private short m_message_code;
    private long m_can_id;

    public CanAeroMetadata(long can_id, AS_IDwidth id29, short node_id) {
        if (can_id <= 0L || (double)can_id > Math.pow(2.0, 29.0)) {
            throw new IllegalArgumentException();
        }
        if (id29 == AS_IDwidth.BIT11 && (double)can_id > Math.pow(2.0, 11.0)) {
            throw new IllegalArgumentException();
        }
        if (node_id <= 0 || node_id > 255) {
            throw new IllegalArgumentException();
        }
        this.m_can_id = id29 == AS_IDwidth.BIT29 ? can_id | Integer.MIN_VALUE : can_id & Integer.MAX_VALUE;
        this.m_message_code = 0;
        this.m_node_id = node_id;
    }

    public long id() {
        return this.m_can_id;
    }

    public boolean isId29() {
        return (this.m_can_id & Integer.MIN_VALUE) != 0L;
    }

    public short nodeId() {
        return this.m_node_id;
    }

    public short increaseMessageCode() {
        this.m_message_code = this.inc8(this.m_message_code);
        return this.m_message_code;
    }

    public boolean checkMessageCode(short new_code) {
        this.m_message_code = this.inc8(this.m_message_code);
        if (this.m_message_code != new_code) {
            System.out.println("Lost " + this.mod(new_code - this.m_message_code, 256) + " packets on id " + (int)(this.id() & Integer.MAX_VALUE));
            this.m_message_code = new_code;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(CanAeroMetadata o) {
        if (this.m_can_id < o.id()) {
            return 1;
        }
        if (this.m_can_id > o.id()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof CanAeroMetadata) {
            CanAeroMetadata other = (CanAeroMetadata)o;
            return other.id() == this.id();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.m_can_id;
    }

    private short inc8(short i) {
        i = (short)(i + 1);
        return (short)(i % 256);
    }

    private int mod(int x, int y) {
        int result = x % y;
        if (result < 0) {
            result += y;
        }
        return result;
    }
}

