/*
 * Decompiled with CFR 0.152.
 */
package com.flightpanels.scs;

import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedClient
implements Comparable<ConnectedClient> {
    private static final float time_out = 15000.0f;
    private short m_node_id;
    private boolean m_poked;
    private Date m_last_heard_of;

    public ConnectedClient(short node_id, short hardware_revision, short software_revision, short identifier_distribution, short header_type) {
        this.m_node_id = node_id;
        this.m_last_heard_of = new Date();
        this.m_poked = false;
    }

    public void resetTimer() {
        this.m_last_heard_of = new Date();
        this.m_poked = false;
    }

    public boolean hasTimedOut() {
        long last_hear = this.m_last_heard_of.getTime();
        long now = new Date().getTime();
        return (float)(now - last_hear) > 15000.0f;
    }

    void poke() {
        this.m_last_heard_of = new Date();
        this.m_poked = true;
    }

    boolean wasPoked() {
        return this.m_poked;
    }

    public short nodeId() {
        return this.m_node_id;
    }

    @Override
    public int compareTo(ConnectedClient rhs) {
        if (this.m_node_id < rhs.nodeId()) {
            return 1;
        }
        if (this.m_node_id > rhs.nodeId()) {
            return -1;
        }
        return 0;
    }
}

