/*
 * Decompiled with CFR 0.152.
 */
package com.flightpanels.scs;

import com.flightpanels.scs.AS_IDwidth;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class can_t {
    long id;
    short dlc;
    short node_id;
    short data_type;
    short service_code;
    short message_code;
    byte[] msg;

    public can_t(long id, short dlc, short node_id, short data_type, short service_code, short message_code, byte[] msg_buffer) {
        assert (msg_buffer.length == 4);
        this.id = id;
        this.dlc = dlc;
        this.node_id = node_id;
        this.data_type = data_type;
        this.service_code = service_code;
        this.message_code = message_code;
        this.msg = msg_buffer;
    }

    public int getIntFromCan() {
        assert (this.data_type == 3);
        return can_t.getSigned32FromRaw(this.msg, 0);
    }

    public short[] getChar4FromCan() {
        assert (this.data_type == 15);
        short[] char4 = new short[4];
        int i = 0;
        while (i < 4) {
            char4[i] = can_t.getUnsigned8FromRaw(this.msg, i);
            ++i;
        }
        return char4;
    }

    public long getUnsignedIntFromCan() {
        assert (this.data_type == 3);
        return can_t.getUnsigned32FromRaw(this.msg, 0);
    }

    public int getFirstUnsignedShortFromCan() {
        assert (this.data_type == 13);
        return can_t.getUnsigned16FromRaw(this.msg, 0);
    }

    public int getSecondUnsignedShortFromCan() {
        assert (this.data_type == 13);
        return can_t.getUnsigned16FromRaw(this.msg, 2);
    }

    public float getFloatFromCan() {
        assert (this.data_type == 2);
        return can_t.getFloatFromRaw(this.msg, 0);
    }

    public double getDoubleFromCan() {
        return this.getFloatFromCan();
    }

    public boolean getBoolFromCan() {
        assert (this.data_type == 10);
        return can_t.getUnsigned8FromRaw(this.msg, 0) != 0;
    }

    public String getStringFromCan() {
        assert (this.data_type == 100);
        int length = this.dlc - 4;
        char[] vc = new char[length];
        int i = 0;
        while (i < length && i < 4) {
            short c = can_t.getUnsigned8FromRaw(this.msg, i);
            vc[i] = c == 0 ? 32 : (char)c;
            ++i;
        }
        if (length == 5) {
            vc[4] = this.service_code == 0 ? 32 : (char)this.service_code;
        }
        return String.copyValueOf(vc);
    }

    public void getStringChunkFromCan(String str) {
        assert (this.data_type == 25);
        char[] vc = new char[4];
        int i = 0;
        while (i < 4) {
            short c = can_t.getUnsigned8FromRaw(this.msg, i);
            vc[i] = c == 0 ? 32 : (char)c;
            ++i;
        }
        short startpos = this.service_code;
        String temp = str.substring(0, 4 * startpos);
        temp.concat(String.copyValueOf(vc));
        temp.concat(str.substring(4 * (startpos + 1), str.length()));
        str = temp;
    }

    public short getUCharFromCan(short position) {
        assert (this.data_type == 10 || this.data_type == 16);
        if (position > 0) {
            assert (position < 4);
            assert (this.data_type == 16);
        }
        return can_t.getUnsigned8FromRaw(this.msg, position);
    }

    public long getUnflaggedIdFromCan() {
        return this.id & Integer.MAX_VALUE;
    }

    public AS_IDwidth getFlagFromCan() {
        return (this.id & Integer.MIN_VALUE) != 0L ? AS_IDwidth.BIT29 : AS_IDwidth.BIT11;
    }

    public int getIndexFromCan() {
        return this.service_code;
    }

    public short getASDataTypeFromCan() {
        return this.data_type;
    }

    public static can_t writeFloatToCan(long id, float data, short message_code, short node_id) {
        byte[] buf = new byte[4];
        long bits = Float.floatToIntBits(data);
        buf = can_t.getRawFromUnsigned32(bits);
        return new can_t(id, 8, node_id, 2, 0, message_code, buf);
    }

    public static can_t writeChar4ToCan(long id, short[] data, short message_code, short node_id) {
        byte[] buf = new byte[4];
        int i = 0;
        while (i < 4) {
            buf[i] = (byte)data[i];
            ++i;
        }
        return new can_t(id, 8, node_id, 2, 0, message_code, buf);
    }

    public static can_t writeIndexedFloatToCan(long id, float data, short index, short message_code, short node_id) {
        can_t can = can_t.writeFloatToCan(id, data, message_code, node_id);
        can.service_code = index;
        return can;
    }

    public static can_t writeIndexedIntToCan(long id, int data, short index, short message_code, short node_id) {
        can_t can = can_t.writeIntToCan(id, data, message_code, node_id);
        can.service_code = index;
        return can;
    }

    public static can_t writeIntToCan(long id, int data, short message_code, short node_id) {
        byte[] buf = new byte[4];
        buf = can_t.getRawFromUnsigned32(data);
        return new can_t(id, 8, node_id, 3, 0, message_code, buf);
    }

    public static can_t writeBoolToCan(long id, boolean data, short message_code, short node_id) {
        byte[] buf = new byte[]{data ? (byte)1 : 0, 0, 0, 0};
        return new can_t(id, 5, node_id, 10, 0, message_code, buf);
    }

    public static can_t writeStringToCan(long id, String data, short message_code, short node_id) {
        short dlc = 4;
        int strlen = data.length();
        short service_code = 0;
        if (strlen > 0) {
            assert (strlen <= 5);
            byte[] buf = new byte[4];
            buf[0] = (byte)data.charAt(0);
            if (strlen > 1) {
                buf[1] = (byte)data.codePointAt(1);
            }
            if (strlen > 2) {
                buf[2] = (byte)data.codePointAt(2);
            }
            if (strlen > 3) {
                buf[3] = (byte)data.codePointAt(3);
            }
            if (strlen > 4) {
                service_code = (byte)data.codePointAt(1);
            }
            dlc = (short)(dlc + strlen);
            return new can_t(id, dlc, node_id, 100, service_code, message_code, buf);
        }
        return new can_t(id, dlc, node_id, 0, service_code, message_code, null);
    }

    public static can_t writeIndexedStringChunkToCan(long id, String data, short index, short message_code, short node_id) {
        short dlc = 4;
        int strlen = data.length();
        assert (strlen <= 4);
        if (strlen > 0) {
            byte[] buf = new byte[4];
            buf[0] = (byte)data.charAt(0);
            buf[1] = (byte)data.codePointAt(1);
            if (strlen > 2) {
                buf[2] = (byte)data.codePointAt(2);
            }
            if (strlen > 3) {
                buf[3] = (byte)data.codePointAt(3);
            }
            return new can_t(id, (short)(dlc + strlen), node_id, 25, index, message_code, buf);
        }
        return new can_t(id, dlc, node_id, 0, index, message_code, null);
    }

    public static can_t writeDRSNodeServiceRequest(short node_id, long param, short requestor, long channel) {
        return can_t.writeNodeServiceRequest(node_id, (short)100, (short)4, can_t.getRawFromUnsigned32(param), requestor, channel);
    }

    public static can_t writeMCSNodeServiceRequest(short node_id, int module, int mode, short requestor, long channel) {
        byte[] buf = new byte[]{(byte)((module & 0xFF00) >> 8), (byte)(module & 0xFF), (byte)((mode & 0xFF00) >> 8), (byte)(mode & 0xFF)};
        return can_t.writeNodeServiceRequest(node_id, (short)13, (short)13, buf, requestor, channel);
    }

    public static can_t writeIDSNodeServiceRequest(short node_id, short requestor, long channel) {
        byte[] buf = new byte[4];
        return can_t.writeNodeServiceRequest(node_id, (short)0, (short)0, buf, requestor, channel);
    }

    public static can_t writeNCSNodeServiceRequest(long node_uuid, long channel) {
        byte[] buf = new byte[4];
        buf = can_t.getRawFromUnsigned32(node_uuid);
        return can_t.writeNodeServiceRequest((short)0, (short)102, (short)4, buf, (short)0, channel);
    }

    public static can_t writeNodeServiceRequest(short node_id, short service_code, short type, byte[] msg_buffer, short msg_code, long channel) {
        return new can_t(channel, 8, node_id, type, service_code, msg_code, msg_buffer);
    }

    public static can_t writeNodeServiceResponse(short node_id, short service_code, short data_type, byte[] message_data, short message_code, long channel) {
        return new can_t(channel, 8, node_id, data_type, service_code, message_code, message_data);
    }

    byte[] getBuff() {
        assert (this.node_id >= 0 && this.node_id < 128);
        assert (this.data_type >= 0 && this.data_type < 128);
        assert (this.service_code >= 0 && this.service_code < 128);
        assert (this.message_code >= 0 && this.message_code < 128);
        byte[] buf = new byte[16];
        buf[0] = (byte)((this.id & 0xFF000000L) >> 24);
        buf[1] = (byte)((this.id & 0xFF0000L) >> 16);
        buf[2] = (byte)((this.id & 0xFF00L) >> 8);
        buf[3] = (byte)(this.id & 0xFFL);
        buf[4] = (byte)(this.node_id & 0xFF);
        buf[5] = (byte)(this.data_type & 0xFF);
        buf[6] = (byte)(this.service_code & 0xFF);
        buf[7] = (byte)(this.message_code & 0xFF);
        int i = 0;
        while (i < 4) {
            buf[8 + i] = this.msg[i];
            ++i;
        }
        buf[12] = (byte)(this.dlc & 0xFF);
        i = 1;
        while (i < 4) {
            buf[12 + i] = 0;
            ++i;
        }
        return buf;
    }

    public int getLength() {
        return 16;
    }

    static can_t receiveRaw(byte[] buf) {
        int index = 0;
        long can_id = can_t.getUnsigned32FromRaw(buf, index);
        short node_id = can_t.getUnsigned8FromRaw(buf, index += 4);
        short data_type = can_t.getUnsigned8FromRaw(buf, ++index);
        short service_code = can_t.getUnsigned8FromRaw(buf, ++index);
        short message_code = can_t.getUnsigned8FromRaw(buf, ++index);
        ++index;
        byte[] msg_buffer = new byte[4];
        int i = 0;
        while (i < 4) {
            msg_buffer[i] = buf[index++];
            ++i;
        }
        short dlc = can_t.getUnsigned8FromRaw(buf, index);
        assert (++index == 13);
        return new can_t(can_id, dlc, node_id, data_type, service_code, message_code, msg_buffer);
    }

    private static long getUnsigned32FromRaw(byte[] buff, int offset) {
        int[] bytes = new int[]{0xFF & buff[offset], 0xFF & buff[offset + 1], 0xFF & buff[offset + 2], 0xFF & buff[offset + 3]};
        return (long)(bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3]) & 0xFFFFFFFFL;
    }

    private static byte[] getRawFromUnsigned32(long arg) {
        byte[] buf = new byte[]{(byte)((arg & 0xFF000000L) >> 24), (byte)((arg & 0xFF0000L) >> 16), (byte)((arg & 0xFF00L) >> 8), (byte)(arg & 0xFFL)};
        return buf;
    }

    private static int getSigned32FromRaw(byte[] buff, int offset) {
        ByteArrayInputStream bstream = new ByteArrayInputStream(buff);
        DataInputStream stream = new DataInputStream(bstream);
        int signed = 0;
        try {
            signed = stream.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return signed;
    }

    private static short getUnsigned8FromRaw(byte[] buff, int offset) {
        int[] bytes = new int[]{0xFF & buff[offset]};
        return (short)bytes[0];
    }

    private static float getFloatFromRaw(byte[] buff, int offset) {
        int bits = (int)can_t.getUnsigned32FromRaw(buff, offset);
        return Float.intBitsToFloat(bits);
    }

    private static int getUnsigned16FromRaw(byte[] buff, int offset) {
        int[] bytes = new int[]{0xFF & buff[offset], 0xFF & buff[offset + 1]};
        return (bytes[0] << 8 | bytes[1]) & 0xFFFF;
    }
}

