package com.flightpanels.android.demo;

import android.app.Activity;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiManager.MulticastLock;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import com.flightpanels.scs.AS_IDwidth;
import com.flightpanels.scs.IUpdateable;
import com.flightpanels.scs.Receiver;

public class Demo extends Activity {
	
	private Button but;
	private Receiver r;
	private Thread receiver_thread;
	private boolean ldg_light;
	private Runnable runner = new Runnable() {

		public void run() {
			while (true) {
				try {
					Thread.sleep(150);
				} catch (Exception e) {
					// TODO: handle exception
					e.printStackTrace();
				}
				r.run();
			}
		}
	};

	private class LandlightHandler implements IUpdateable<Boolean> {

		@Override
		public void update(Boolean arg0) {
			// TODO Auto-generated method stub
			try {
				if (arg0) {
					runOnUiThread(new Runnable() {
						
						@Override
						public void run() {
							but.setText("LDG lights now ON, toggle OFF");
						}
					});
					ldg_light = true;
				} else {
					runOnUiThread(new Runnable() {
						
						@Override
						public void run() {
							but.setText("LDG lights now OFF, toggle ON");
						}
					});
					ldg_light = false;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
	}
	
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		but = (Button) findViewById(R.id.Button01);
		short demo_sw_revision = 1;
		short demo_node_id = 255;
		WifiManager wifi = (WifiManager)getSystemService(Context.WIFI_SERVICE);
		MulticastLock lock = wifi.createMulticastLock("mylock");
		lock.acquire();

		r = new Receiver(demo_sw_revision, demo_node_id, "239.40.41.42",
				50707, 50707);
		receiver_thread = new Thread(runner);
		receiver_thread.start();
		r.requestData((long)1512, AS_IDwidth.BIT29, new LandlightHandler(), new Boolean(false));

	}

	// This method is called at button click because we assigned the name to the
	// "On Click property" of the button
	public void myClickHandler(View view) {
		switch (view.getId()) {
		case R.id.Button01:
			if (ldg_light)
				r.sendData(1512, AS_IDwidth.BIT29, new Boolean(false));
			else
				r.sendData(1512, AS_IDwidth.BIT29, new Boolean(true));
			break;
		}
	}

}
