/*
 * Decompiled with CFR 0.152.
 */
package com.flightpanels.scs;

import com.flightpanels.scs.CanAeroMetadata;
import com.flightpanels.scs.IDataReference;
import com.flightpanels.scs.IUpdateable;
import com.flightpanels.scs.can_t;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataReference<T>
implements IDataReference {
    private List<IUpdateable<T>> m_func_ptr = new ArrayList<IUpdateable<T>>();
    protected T m_cached_value;
    protected T m_history_value;
    protected boolean m_has_changed;
    protected Date m_last_received;

    public DataReference(IUpdateable<T> updateable) {
        this.m_func_ptr.add(updateable);
        this.m_last_received = new Date(0L);
    }

    @Override
    public void signUp(IUpdateable ref) {
        ref.update(this.m_cached_value);
        this.m_func_ptr.add(ref);
    }

    @Override
    public boolean hasChanged() {
        return this.m_has_changed;
    }

    @Override
    public boolean needsRequest() {
        long last = this.m_last_received.getTime();
        long now = new Date().getTime();
        return now - last > 15000L;
    }

    @Override
    public abstract void readFromCan(CanAeroMetadata var1, can_t var2);

    @Override
    public void requested() {
        this.m_last_received = new Date();
    }

    @Override
    public void update() {
        if (this.m_has_changed) {
            for (IUpdateable<T> func_ptr : this.m_func_ptr) {
                func_ptr.update(this.m_cached_value);
            }
            this.m_has_changed = false;
        }
    }

    @Override
    public can_t write(CanAeroMetadata meta, Object value) {
        return this.writeToCan(meta, value);
    }

    protected void checkMessageCode(CanAeroMetadata meta, short msg_code) {
        meta.checkMessageCode(msg_code);
    }

    protected void received() {
        this.m_history_value = this.m_cached_value;
        this.m_last_received = new Date();
    }

    protected abstract can_t writeToCan(CanAeroMetadata var1, Object var2);
}

