/*
 * Decompiled with CFR 0.152.
 */
package com.flightpanels.scs;

import com.flightpanels.scs.AS_IDwidth;
import com.flightpanels.scs.CanAeroBusConnector;
import com.flightpanels.scs.CanAeroMetadata;
import com.flightpanels.scs.DataReferenceBool;
import com.flightpanels.scs.DataReferenceChar4;
import com.flightpanels.scs.DataReferenceDouble;
import com.flightpanels.scs.DataReferenceFloat;
import com.flightpanels.scs.DataReferenceFloatVector;
import com.flightpanels.scs.DataReferenceInt;
import com.flightpanels.scs.DataReferenceString;
import com.flightpanels.scs.ICanAeroDataManager;
import com.flightpanels.scs.IDataReference;
import com.flightpanels.scs.IUpdateable;
import com.flightpanels.scs.UDPConnector;
import com.flightpanels.scs.can_t;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Receiver
implements ICanAeroDataManager {
    private ConcurrentHashMap<CanAeroMetadata, IDataReference> m_data_map;
    private UDPConnector m_network_connector;
    private CanAeroBusConnector m_bus_connector;
    private long counter;

    Receiver(short required_software_revision, short own_node_id, String host_addr, int incoming_port, int outgoing_port) {
        this.m_network_connector = new UDPConnector(host_addr, incoming_port, outgoing_port);
        this.m_bus_connector = new CanAeroBusConnector(this, this.m_network_connector, own_node_id, required_software_revision);
        this.m_data_map = new ConcurrentHashMap();
    }

    public void requestData(long id, AS_IDwidth id29, IUpdateable<Integer> update, Integer ref) {
        CanAeroMetadata meta = new CanAeroMetadata(id, id29, this.m_bus_connector.ownNodeId());
        if (!this.m_data_map.containsKey(meta)) {
            DataReferenceInt data = new DataReferenceInt(update);
            this.m_data_map.put(meta, data);
        } else {
            this.m_data_map.get(meta).signUp(update);
        }
    }

    public void requestData(long id, AS_IDwidth id29, IUpdateable<Float> update, Float ref) {
        CanAeroMetadata meta = new CanAeroMetadata(id, id29, this.m_bus_connector.ownNodeId());
        if (!this.m_data_map.containsKey(meta)) {
            DataReferenceFloat data = new DataReferenceFloat(update);
            this.m_data_map.put(meta, data);
        } else {
            this.m_data_map.get(meta).signUp(update);
        }
    }

    public void requestData(long id, AS_IDwidth id29, IUpdateable<Double> update, Double ref) {
        CanAeroMetadata meta = new CanAeroMetadata(id, id29, this.m_bus_connector.ownNodeId());
        if (!this.m_data_map.containsKey(meta)) {
            DataReferenceDouble data = new DataReferenceDouble(update);
            this.m_data_map.put(meta, data);
        } else {
            this.m_data_map.get(meta).signUp(update);
        }
    }

    public void requestData(long id, AS_IDwidth id29, IUpdateable<ArrayList<Short>> update, ArrayList<Short> ref) {
        CanAeroMetadata meta = new CanAeroMetadata(id, id29, this.m_bus_connector.ownNodeId());
        if (!this.m_data_map.containsKey(meta)) {
            DataReferenceChar4 data = new DataReferenceChar4(update);
            this.m_data_map.put(meta, data);
        } else {
            this.m_data_map.get(meta).signUp(update);
        }
    }

    public void requestData(long id, AS_IDwidth id29, IUpdateable<Boolean> update, Boolean ref) {
        CanAeroMetadata meta = new CanAeroMetadata(id, id29, this.m_bus_connector.ownNodeId());
        if (!this.m_data_map.containsKey(meta)) {
            DataReferenceBool data = new DataReferenceBool(update);
            this.m_data_map.put(meta, data);
        } else {
            this.m_data_map.get(meta).signUp(update);
        }
    }

    public void requestData(long id, AS_IDwidth id29, IUpdateable<String> update, String ref) {
        CanAeroMetadata meta = new CanAeroMetadata(id, id29, this.m_bus_connector.ownNodeId());
        if (!this.m_data_map.containsKey(meta)) {
            DataReferenceString data = new DataReferenceString(update);
            this.m_data_map.put(meta, data);
        } else {
            this.m_data_map.get(meta).signUp(update);
        }
    }

    public void requestData(long id, AS_IDwidth id29, IUpdateable<Vector<Float>> update, Vector<Float> ref) {
        CanAeroMetadata meta = new CanAeroMetadata(id, id29, this.m_bus_connector.ownNodeId());
        if (!this.m_data_map.containsKey(meta)) {
            DataReferenceFloatVector data = new DataReferenceFloatVector(update);
            this.m_data_map.put(meta, data);
        } else {
            this.m_data_map.get(meta).signUp(update);
        }
    }

    @Override
    public boolean handleDRS(long id) {
        return false;
    }

    @Override
    public void handleMCS(int module, int mode) {
    }

    @Override
    public void handleSTS() {
    }

    @Override
    public void handleMIS() {
    }

    @Override
    public void incomingData(can_t msg) {
        CanAeroMetadata meta = new CanAeroMetadata(msg.getUnflaggedIdFromCan(), msg.getFlagFromCan(), this.m_bus_connector.ownNodeId());
        Set keyset = this.m_data_map.keySet();
        for (CanAeroMetadata m : keyset) {
            if (!m.equals(meta)) continue;
            meta = m;
        }
        IDataReference it = this.m_data_map.get(meta);
        if (it != null) {
            it.readFromCan(meta, msg);
        }
    }

    public void sendData(long id, AS_IDwidth id29, Object value) {
        CanAeroMetadata meta = new CanAeroMetadata(id & Integer.MAX_VALUE, id29, this.m_bus_connector.ownNodeId());
        Set keyset = this.m_data_map.keySet();
        for (CanAeroMetadata key : keyset) {
            if (meta.id() != key.id()) continue;
            meta = key;
        }
        IDataReference it = this.m_data_map.get(meta);
        if (it != null) {
            this.m_bus_connector.send(it.write(meta, value));
        }
    }

    public void run() {
        if (++this.counter % 10L == 0L) {
            this.m_bus_connector.doHouseKeeping();
        }
        for (CanAeroMetadata meta : this.m_data_map.keySet()) {
            if (this.m_data_map.get(meta).needsRequest()) {
                this.m_bus_connector.sendDRS(meta.id() & Integer.MAX_VALUE, (meta.id() & Integer.MIN_VALUE) != 0L, this.m_bus_connector.ownNodeId());
                this.m_data_map.get(meta).requested();
            }
            this.m_data_map.get(meta).update();
        }
    }
}

