/*
 * Decompiled with CFR 0.152.
 */
package com.flightpanels.scs;

import com.flightpanels.scs.IBusConnector;
import com.flightpanels.scs.INetworkConnector;
import com.flightpanels.scs.can_t;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPConnector
implements INetworkConnector<can_t> {
    private InetAddress group;
    private MulticastSocket s;
    private IBusConnector<can_t> m_connector;
    private Thread m_receiver_thread;
    private int port_outgoing;
    private boolean m_thread_should_stop = false;
    private Runnable receiver = new Runnable(){

        public void run() {
            byte[] buf = new byte[1440];
            while (!UDPConnector.this.m_thread_should_stop) {
                DatagramPacket pack = new DatagramPacket(buf, buf.length);
                try {
                    UDPConnector.this.s.receive(pack);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (pack.getLength() % 16 != 0) {
                    throw new RuntimeException("Corrupted or malformed CAN Aerospace dataframe received.");
                }
                int num_of_can = pack.getLength() / 16;
                for (int i = 0; i < num_of_can; ++i) {
                    byte[] can_buffer = new byte[16];
                    for (int j = 0; j < 16; ++j) {
                        can_buffer[j] = buf[j + i * 16];
                    }
                    UDPConnector.this.receive(can_t.receiveRaw(can_buffer));
                }
            }
        }
    };

    public UDPConnector(String host_addr, int incoming_port, int outgoing_port) {
        this.port_outgoing = outgoing_port;
        try {
            this.group = InetAddress.getByName(host_addr);
            this.s = new MulticastSocket(incoming_port);
            this.s.setReuseAddress(true);
            this.s.setTimeToLive(2);
            this.s.joinGroup(this.group);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_receiver_thread = new Thread(this.receiver);
        this.m_receiver_thread.start();
    }

    protected void finalize() throws Throwable {
        this.m_thread_should_stop = true;
        try {
            this.s.leaveGroup(this.group);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.s.close();
    }

    @Override
    public void send(can_t msg) {
        DatagramPacket p = new DatagramPacket(msg.getBuff(), msg.getLength(), this.group, this.port_outgoing);
        try {
            this.s.send(p);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setListener(IBusConnector<can_t> listener) {
        this.m_connector = listener;
    }

    private void receive(can_t msg) {
        this.m_connector.receiveMessage(msg);
    }
}

