package com.flightpanels.scs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.*;

import com.flightpanels.scs.AS_IDwidth;

public class Demo {

	public Demo() {
		receiver = new Receiver(demo_sw_revision, demo_node_id, "239.40.41.42",
				50707, 50707);

		receiver_thread = new Thread(runner);
		receiver_thread.start();

		initGui();
	}

	private void initGui() {

		frame = new JFrame("SCS for Java Demo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		tabpane = new JTabbedPane();
		frame.getContentPane().add(tabpane);

		RowsCountingPanel firstpanel = new RowsCountingPanel();
		
		firstpanel.setLayout(new SpringLayout());
		firstpanel.setCols(5);
		firstpanel.add(new JLabel("ID"));
		firstpanel.add(new JLabel("Name"));
		firstpanel.add(new JLabel("Request"));
		firstpanel.add(new JLabel("Value"));
		firstpanel.add(new JLabel("Write"));

		firstpanel.incRows();
		
		createFloatWidget(firstpanel, "pitch rate (deg/s) + is up", 303, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "bank rate (deg/s) + is right", 304, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "yaw rate (deg/s) + is right", 305, AS_IDwidth.BIT11);
		
		createFloatWidget(firstpanel, "pitch (deg) + is up", 311, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "bank (deg) + is right", 312, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "sideslip (deg) + is yaw right", 313, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "VS (m/s)", 314, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "IAS (m/s)", 315, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "TAS (m/s)", 316, AS_IDwidth.BIT11);
		
		createFloatWidget(firstpanel, "mach", 318, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "baro (hPa)", 319, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "baro corr. ALT (m)", 320, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "HDG angle (deg)", 321, AS_IDwidth.BIT11);
		
		createFloatWidget(firstpanel, "TAT (K)", 323, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "OAT (K)", 324, AS_IDwidth.BIT11);
		
		createFloatWidget(firstpanel, "AOA (deg) + is up", 328, AS_IDwidth.BIT11);
		
		createFloatWidget(firstpanel, "true ALT (m)", 332, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "wind spd (m/s)", 333, AS_IDwidth.BIT11);
		createFloatWidget(firstpanel, "wind dir angle true (deg)", 334, AS_IDwidth.BIT11);
		SpringUtilities.makeCompactGrid(firstpanel, firstpanel.getRows(),
				firstpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("300-399", firstpanel);
		
		RowsCountingPanel secondpanel = new RowsCountingPanel();
		
		secondpanel.setLayout(new SpringLayout());
		secondpanel.setCols(5);
		secondpanel.add(new JLabel("ID"));
		secondpanel.add(new JLabel("Name"));
		secondpanel.add(new JLabel("Request"));
		secondpanel.add(new JLabel("Value"));
		secondpanel.add(new JLabel("Write"));

		secondpanel.incRows();
			
		createFloatWidget(secondpanel, "elevator input", 400, AS_IDwidth.BIT11);
		createFloatWidget(secondpanel, "aileron input", 401, AS_IDwidth.BIT11);
		createFloatWidget(secondpanel, "rudder input", 403, AS_IDwidth.BIT11);
		createFloatWidget(secondpanel, "elevtaor trim", 405, AS_IDwidth.BIT11);
		createFloatVectorWidget(secondpanel, "throttle input", 418, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		createFloatWidget(secondpanel, "Flap lever", 430, AS_IDwidth.BIT11);
		createFloatWidget(secondpanel, "Parkbrake", 432, AS_IDwidth.BIT11);
		createFloatWidget(secondpanel, "speedbrake lever", 433, AS_IDwidth.BIT11);
		createFloatWidget(secondpanel, "left brake", 435, AS_IDwidth.BIT11);
		createFloatWidget(secondpanel, "right brake", 436, AS_IDwidth.BIT11);
		createBoolWidget(secondpanel, "Stall warn horn", 442, AS_IDwidth.BIT11);
		
		createFloatVectorWidget(secondpanel, "Engine N1", 500, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		createFloatVectorWidget(secondpanel, "Engine N2", 504, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		createFloatVectorWidget(secondpanel, "Engine EGT", 520, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		createFloatVectorWidget(secondpanel, "Engine FF", 524, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		
		
		SpringUtilities.makeCompactGrid(secondpanel, secondpanel.getRows(),
				secondpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("400-999", secondpanel);
		
		RowsCountingPanel thirdpanel = new RowsCountingPanel();
		thirdpanel.setLayout(new SpringLayout());
		thirdpanel.setCols(5);
		thirdpanel.add(new JLabel("ID"));
		thirdpanel.add(new JLabel("Name"));
		thirdpanel.add(new JLabel("Request"));
		thirdpanel.add(new JLabel("Value"));
		thirdpanel.add(new JLabel("Write"));

		thirdpanel.incRows();

		createFloatWidget(thirdpanel, "LAT", 1036, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "LON", 1037, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "GS", 1039, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "mag. track (deg)", 1041, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "heigth AGL (m)", 1070, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "DME1 dist", 1071, AS_IDwidth.BIT29);
		createFloatWidget(thirdpanel, "DME2 dist", 1072, AS_IDwidth.BIT29);
		
		createFloatWidget(thirdpanel, "ADF1 brg", 1083, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "ADF2 brg", 1084, AS_IDwidth.BIT11);
		
		createFloatWidget(thirdpanel, "NAV1 LOC dev", 1087, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "NAV2 LOC dev", 1088, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "NAV1 GS  dev", 1091, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "NAV2 GS  dev", 1092, AS_IDwidth.BIT11);
		
		createFloatWidget(thirdpanel, "FD pitch dev", 1095, AS_IDwidth.BIT11);
		createFloatWidget(thirdpanel, "FD bank dev", 1097, AS_IDwidth.BIT11);

		SpringUtilities.makeCompactGrid(thirdpanel, thirdpanel.getRows(),
				thirdpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("1000-1099", thirdpanel);

		RowsCountingPanel fourthpanel = new RowsCountingPanel();
		fourthpanel.setLayout(new SpringLayout());
		fourthpanel.setCols(5);
		fourthpanel.add(new JLabel("ID"));
		fourthpanel.add(new JLabel("Name"));
		fourthpanel.add(new JLabel("Request"));
		fourthpanel.add(new JLabel("Value"));
		fourthpanel.add(new JLabel("Write"));

		fourthpanel.incRows();
		
		createWriteableIntWidget(fourthpanel, "COM1 freq", 1100, AS_IDwidth.BIT29, 118000,
				136000, 25, true);
		createWriteableIntWidget(fourthpanel, "COM2 freq", 1101, AS_IDwidth.BIT29, 118000,
				136000, 25, true);
		createWriteableIntWidget(fourthpanel, "NAV1 freq", 1104, AS_IDwidth.BIT29, 108000,
				117950, 50, false);
		createWriteableIntWidget(fourthpanel, "NAV2 freq", 1105, AS_IDwidth.BIT29, 108000,
				117950, 50, false);
		createWriteableIntWidget(fourthpanel, "ADF1 freq", 1108, AS_IDwidth.BIT11,1000,999000,1000,false);
		createWriteableIntWidget(fourthpanel, "ADF2 freq", 1109, AS_IDwidth.BIT11,1000,999000,1000,false);
		createWriteableIntWidget(fourthpanel, "XPDR", 1116, AS_IDwidth.BIT11, 0000, 7777, 1, false);
		
		createFloatWidget(fourthpanel, "mag VAR (deg)", 1121, AS_IDwidth.BIT11);
		createFloatWidget(fourthpanel, "OBS1 mag", 1126, AS_IDwidth.BIT11);
		createFloatWidget(fourthpanel, "OBS2 mag", 1127, AS_IDwidth.BIT11);

		createBoolWidget(fourthpanel, "onground", 1176, AS_IDwidth.BIT11);
		createChar4Widget(fourthpanel, "Zulu time secs", 1200, AS_IDwidth.BIT11);
		createChar4Widget(fourthpanel, "local date days", 1206, AS_IDwidth.BIT11);
		
		SpringUtilities.makeCompactGrid(fourthpanel, fourthpanel.getRows(),
				fourthpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("1100-1299", fourthpanel);

		RowsCountingPanel fifthpanel = new RowsCountingPanel();
		fifthpanel.setLayout(new SpringLayout());
		fifthpanel.setCols(5);
		fifthpanel.add(new JLabel("ID"));
		fifthpanel.add(new JLabel("Name"));
		fifthpanel.add(new JLabel("Request"));
		fifthpanel.add(new JLabel("Value"));
		fifthpanel.add(new JLabel("Write"));

		fifthpanel.incRows();
		
		createBoolToggleWidget(fifthpanel, "Avionics power", 1500, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Battery power", 1501, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Beacon light", 1510, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Strobe light", 1511, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Land light", 1512, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Nav light", 1513, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Taxi light", 1514, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Instr light", 1515, AS_IDwidth.BIT29);
		
		createFloatVectorWidget(fifthpanel, "Eng. Anti-ICE", 1520, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		createBoolToggleWidget(fifthpanel, "Pitot heat", 1521, AS_IDwidth.BIT29);

		createIntWidget(fifthpanel, "Autopilot flags", 1531, AS_IDwidth.BIT29);
		createFloatWidget(fifthpanel, "ap v/s (m/s)", 1532, AS_IDwidth.BIT29);
		createFloatWidget(fifthpanel, "ap alt (m)", 1533, AS_IDwidth.BIT29);
		createFloatWidget(fifthpanel, "ap hdg (deg mag)", 1534, AS_IDwidth.BIT29);
		createFloatWidget(fifthpanel, "ap airspeed (m/s)", 1535, AS_IDwidth.BIT29);
		createFloatWidget(fifthpanel, "ap mach", 1536, AS_IDwidth.BIT29);
		createIntWidget(fifthpanel, "FD switch", 1537, AS_IDwidth.BIT29);
		createIntWidget(fifthpanel, "Autopilot fgs state", 1538, AS_IDwidth.BIT29);
		createFloatWidget(fifthpanel, "a/p hdg override (deg mag)", 1539, AS_IDwidth.BIT29);
		createBoolWidget(fifthpanel, "gps enabled", 1540, AS_IDwidth.BIT29);
		

		SpringUtilities.makeCompactGrid(fifthpanel, fifthpanel.getRows(),
				fifthpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("1300-1549", fifthpanel);
		
		RowsCountingPanel sixthpanel = new RowsCountingPanel();
		sixthpanel.setLayout(new SpringLayout());
		sixthpanel.setCols(5);
		sixthpanel.add(new JLabel("ID"));
		sixthpanel.add(new JLabel("Name"));
		sixthpanel.add(new JLabel("Request"));
		sixthpanel.add(new JLabel("Value"));
		sixthpanel.add(new JLabel("Write"));

		sixthpanel.incRows();
		
		createFloatWidget(sixthpanel, "Vs0", 1550, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "Vs", 1551, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "Vc", 1552, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "Vmd", 1553, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "Mmo", 1554, AS_IDwidth.BIT29);
		createIntWidget(sixthpanel, "no of eng", 1555, AS_IDwidth.BIT29);
		createIntWidget(sixthpanel, "flap detents", 1556, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "fuel capacity (kg)", 1557, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "max gross wt (kg)", 1558, AS_IDwidth.BIT29);
		
		createFloatVectorWidget(sixthpanel, "Gear deployment", 1560, AS_IDwidth.BIT29, 1556, AS_IDwidth.BIT29);
		createFloatVectorWidget(sixthpanel, "Thrust reverser", 1561, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		createBoolWidget(sixthpanel, "Spoilers armed", 1562, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "Flaps degrees", 1563, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "left flaps %", 1564, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "right flaps  %", 1565, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "barber pole speed", 1566, AS_IDwidth.BIT29);
		
		createFloatWidget(sixthpanel, "total weight (kg)", 1570, AS_IDwidth.BIT29);
		createFloatWidget(sixthpanel, "zero fuel wt(kg)", 1571, AS_IDwidth.BIT29);
		
		createIntWidget(sixthpanel, "EFIS 1", 1580, AS_IDwidth.BIT29);
		createIntWidget(sixthpanel, "EFIS 2", 1581, AS_IDwidth.BIT29);
		
		createBoolWidget(sixthpanel, "door open", 1590, AS_IDwidth.BIT29);
		createBoolWidget(sixthpanel, "seat belts", 1591, AS_IDwidth.BIT29);
		createBoolWidget(sixthpanel, "no smoking", 1592, AS_IDwidth.BIT29);
		
		SpringUtilities.makeCompactGrid(sixthpanel, sixthpanel.getRows(),
				sixthpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("1550-1599", sixthpanel);
		
		RowsCountingPanel seventhpanel = new RowsCountingPanel();
		seventhpanel.setLayout(new SpringLayout());
		seventhpanel.setCols(5);
		seventhpanel.add(new JLabel("ID"));
		seventhpanel.add(new JLabel("Name"));
		seventhpanel.add(new JLabel("Request"));
		seventhpanel.add(new JLabel("Value"));
		seventhpanel.add(new JLabel("Write"));

		seventhpanel.incRows();
		createIntWidget(seventhpanel, "NAV1 from/to", 1600, AS_IDwidth.BIT29);
		createIntWidget(seventhpanel, "NAV2 from/to", 1601, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "NAV1 has dme", 1602, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "NAV2 has dme", 1603, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "ADF1 tuned", 1604, AS_IDwidth.BIT29);
		createStringWidget(seventhpanel, "NDB1 id", 1605, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "NDB1 Lat", 1606, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "NDB1 Lon", 1607, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "ADF2 tuned", 1608, AS_IDwidth.BIT29);
		createStringWidget(seventhpanel, "NDB2 id", 1609, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "NDB2 Lat", 1610, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "NDB2 Lon", 1611, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "NAV1 tuned", 1612, AS_IDwidth.BIT29);
		createStringWidget(seventhpanel, "VOR1 Id", 1613, AS_IDwidth.BIT29);		
		createFloatWidget(seventhpanel, "VOR1 Lat", 1614, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "VOR1 Lon", 1615, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "VOR1 has loc", 1616, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "VOR1 loc crs", 1617, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "VOR1 gs incl", 1618, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "NAV2 tuned", 1619, AS_IDwidth.BIT29);
		createStringWidget(seventhpanel, "VOR2 Id", 1620, AS_IDwidth.BIT29);		
		createFloatWidget(seventhpanel, "VOR2 Lat", 1621, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "VOR2 Lon", 1622, AS_IDwidth.BIT29);
		createBoolWidget(seventhpanel, "VOR2 has loc", 1623, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "VOR2 loc crs", 1624, AS_IDwidth.BIT29);
		createFloatWidget(seventhpanel, "VOR2 gs incl", 1625, AS_IDwidth.BIT29);
		createIntWidget(seventhpanel, "nav flags", 1626, AS_IDwidth.BIT29);

		SpringUtilities.makeCompactGrid(seventhpanel, seventhpanel.getRows(),
				seventhpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("1600-1649", seventhpanel);

		RowsCountingPanel eigthpanel = new RowsCountingPanel();
		eigthpanel.setLayout(new SpringLayout());
		eigthpanel.setCols(5);
		eigthpanel.add(new JLabel("ID"));
		eigthpanel.add(new JLabel("Name"));
		eigthpanel.add(new JLabel("Request"));
		eigthpanel.add(new JLabel("Value"));
		eigthpanel.add(new JLabel("Write"));

		eigthpanel.incRows();
		createBoolWidget(eigthpanel, "throttl over.", 1652, AS_IDwidth.BIT29);
		createFloatVectorWidget(eigthpanel, "throttl over. pos", 1655, AS_IDwidth.BIT29, 1555, AS_IDwidth.BIT29);
		
		createBoolToggleWidget(eigthpanel, "sim paused", 1660, AS_IDwidth.BIT29);
		createFloatWidget(eigthpanel, "QNH", 1661, AS_IDwidth.BIT29);
		createFloatWidget(eigthpanel, "dewpoi sealvl", 1662, AS_IDwidth.BIT29);
		createFloatWidget(eigthpanel, "speed of sound (m/s)", 1663, AS_IDwidth.BIT29);
		
		createBoolToggleWidget(eigthpanel, "MCP w/o vasFMC", 1700, AS_IDwidth.BIT29);
		createWriteableIntWidget(eigthpanel, "mcp IAS/MACH", 1701, AS_IDwidth.BIT29,0,359,1,false);
		createWriteableIntWidget(eigthpanel, "mcp HDG", 1702, AS_IDwidth.BIT29,0,359,1,false);
		createWriteableIntWidget(eigthpanel, "mcp ALT", 1703, AS_IDwidth.BIT29, 0, 60000, 1000, false);
		createWriteableIntWidget(eigthpanel, "mcp V/S", 1704, AS_IDwidth.BIT29,-6000,6000,100, false);
		createIntWidget(eigthpanel, "mcp button lights", 1705, AS_IDwidth.BIT29);
		createIntWidget(eigthpanel, "mcp back light", 1706, AS_IDwidth.BIT29);
		createIntWidget(eigthpanel, "mcp A/T", 1707, AS_IDwidth.BIT29);
		createIntWidget(eigthpanel, "mcp button presses", 1708, AS_IDwidth.BIT29);
		createWriteableIntWidget(eigthpanel, "mcp CRS1", 1709, AS_IDwidth.BIT29,0,359,1, false);
		createWriteableIntWidget(eigthpanel, "mcp CRS2", 1710, AS_IDwidth.BIT29,0,359,1, false);
		createBoolWidget(eigthpanel, "Outer marker", 1712, AS_IDwidth.BIT29);
		createBoolWidget(eigthpanel, "Middle marker", 1713, AS_IDwidth.BIT29);
		createBoolWidget(eigthpanel, "Inner marker", 1714, AS_IDwidth.BIT29);
		createFloatWidget(eigthpanel, "instr brightness", 1800, AS_IDwidth.BIT29);
		
		SpringUtilities.makeCompactGrid(eigthpanel, eigthpanel.getRows(),
				eigthpanel.getCols(), 3, 3, 3, 3);
		tabpane.addTab("1650-1800", eigthpanel);
				

		frame.pack();
		frame.setVisible(true);
	}

	private void createFloatVectorWidget(RowsCountingPanel parent, String name,
			final int id_values, final AS_IDwidth id29_values,
			final int id_length, final AS_IDwidth id29_length) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id_values)));
		parent.add(new JLabel(name));
		JButton request_button = new JButton("Request");
		JPanel vector_panel = new JPanel();
		final ResizeableSpinnersPanel spinners_panel = new ResizeableSpinnersPanel(
				vector_panel, parent, (parent.getRows()-1)*parent.getCols()+3);
		final UpdateableFloatVectorSpinners spinners = new UpdateableFloatVectorSpinners(
				spinners_panel);
		request_button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				receiver.requestData(id_length, id29_length, spinners_panel,
						new Integer(0));
				receiver.requestData(id_values, id29_values, spinners,
						new Vector<Float>());
			}
		});
		parent.add(request_button);
		parent.add(vector_panel);
		parent.add(new JLabel(""));
	}

	private void createWriteableIntWidget(RowsCountingPanel parent,
			String name, final int id, final AS_IDwidth id29, int min, int max,
			int step, boolean com) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id)));
		parent.add(new JLabel(name));
		SpinnerModel model = new SpinnerNumberModel(min, min, max, step);
		final JSpinner spin = new JSpinner(model);
		spin.setEnabled(true);
		final UpdateableIntSpinner uis = new UpdateableIntSpinner(spin, com);
		JButton request_button = new JButton("Request");
		request_button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				receiver.requestData(id, id29, uis, new Integer(0));
			}
		});
		parent.add(request_button);
		parent.add(spin);
		JButton write = new JButton("Write");
		write.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				int freq =  (Integer) (spin.getModel().getValue());
				if (freq%2!=0)
					freq-=5;
				receiver.sendData(id, id29, freq);
			}
		});
		parent.add(write);
	}

	private void createFloatWidget(RowsCountingPanel parent, String name,
			final int id, final AS_IDwidth id29) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id)));
		parent.add(new JLabel(name));
		JButton request_button = new JButton("Request");
		JSpinner spin = new JSpinner();
		spin.setEnabled(false);
		final UpdateableFloatSpinner ufs = new UpdateableFloatSpinner(spin);
		request_button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				receiver.requestData(id, id29, ufs, new Float(0));
			}
		});
		parent.add(request_button);
		parent.add(spin);
		parent.add(new JLabel(""));
	}
	
	private void createChar4Widget(RowsCountingPanel parent, String name,
			final int id, final AS_IDwidth id29) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id)));
		parent.add(new JLabel(name));
		JButton request_button = new JButton("Request");
		JSpinner[] spin = new JSpinner[4];
		for (int i = 0 ; i < 4 ; ++i)
		{	spin[i] = new JSpinner();
			spin[i].setEnabled(false);
		}
		final UpdateableChar4Spinners ufs = new UpdateableChar4Spinners(spin);
		request_button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				receiver.requestData(id, id29, ufs, new ArrayList<Short>());
			}
		});
		parent.add(request_button);
		JPanel spinners_panel = new JPanel();
		spinners_panel.setLayout(new SpringLayout());
		for (int i = 0 ; i < 4 ; ++i) 
			spinners_panel.add(spin[i]);
		parent.add(spinners_panel);
		parent.add(new JLabel(""));
		SpringUtilities.makeCompactGrid(spinners_panel,
				1, 4, 3, 3, 
				3, 3);
	}
	
	private void createIntWidget(RowsCountingPanel parent, String name,
			final int id, final AS_IDwidth id29) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id)));
		parent.add(new JLabel(name));
		JButton request_button = new JButton("Request");
		JSpinner spin = new JSpinner();
		spin.setEnabled(false);
		final UpdateableIntSpinner uis = new UpdateableIntSpinner(spin);
		request_button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent arg0) {
				receiver.requestData(id, id29, uis, new Integer(0));
			}
		});
		parent.add(request_button);
		parent.add(spin);
		parent.add(new JLabel(""));
	}

	private void createBoolToggleWidget(RowsCountingPanel parent, String name,
			final int id, final AS_IDwidth id29) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id)));
		parent.add(new JLabel(name));
		JButton request_button = new JButton("Request");
		JSpinner spin = new JSpinner();
		spin.setEnabled(false);
		final UpdateableBoolSpinner ubs = new UpdateableBoolSpinner(spin);
		request_button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				receiver.requestData(id, id29, ubs, new Boolean(false));
			}
		});
		parent.add(request_button);
		parent.add(spin);
		JButton toggle = new JButton("Toggle");
		toggle.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				if (ubs.getValue())
					receiver.sendData(id, id29, false);
				else
					receiver.sendData(id, id29, true);
			}
		});
		parent.add(toggle);
	}

	private void createBoolWidget(RowsCountingPanel parent, String name,
			final int id, final AS_IDwidth id29) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id)));
		parent.add(new JLabel(name));
		JButton request_button = new JButton("Request");
		JSpinner spin = new JSpinner();
		spin.setEnabled(false);
		final UpdateableBoolSpinner ubs = new UpdateableBoolSpinner(spin);
		request_button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				receiver.requestData(id, id29, ubs, new Boolean(false));
			}
		});
		parent.add(request_button);
		parent.add(spin);
		parent.add(new JLabel(""));
	}

	private void createStringWidget(RowsCountingPanel parent, String name,
			final int id, final AS_IDwidth id29) {
		parent.incRows();
		parent.add(new JLabel(String.valueOf(id)));
		parent.add(new JLabel(name));
		JButton request_button = new JButton("Request");
		JLabel label = new JLabel("");
		final UpdateableStringLabel usl = new UpdateableStringLabel(label);
		request_button.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				receiver.requestData(id, id29, usl, new String(""));
			}
		});
		parent.add(request_button);
		parent.add(label);
		parent.add(new JLabel(""));

	}

	private Runnable runner = new Runnable() {

		public void run() {
			while (true) {
				try {
					Thread.sleep(150);
				} catch (Exception e) {
					// TODO: handle exception
					e.printStackTrace();
				}
				receiver.run();
			}
		}
	};

	private Receiver receiver;
	private Thread receiver_thread;
	private JFrame frame;
	private JTabbedPane tabpane;

	private static final short demo_sw_revision = 1;
	private static final short demo_node_id = 255;

	public static void main(String[] args) {
		@SuppressWarnings("unused")
		Demo m = new Demo();
	}

}
