package com.flightpanels.scs;

import java.awt.GridLayout;
import java.util.Vector;

import javax.swing.JPanel;
import javax.swing.JSpinner;

public  class ResizeableSpinnersPanel implements IUpdateable<Integer> {

	public ResizeableSpinnersPanel(JPanel parent, RowsCountingPanel grandparent, int position) {
		m_current_value = 0;
		m_grandparent = grandparent;
		m_parent = parent;
		m_spinners = new Vector<JSpinner>();
		m_position = position; 
	}

	public void update(Integer value) {
		if (value == m_current_value)
			return;
		m_current_value = value;
		m_grandparent.remove(m_parent);
		m_parent = new JPanel();
		m_parent.setLayout(new GridLayout(1, m_current_value));
		m_spinners = new Vector<JSpinner>();
		for (int i = 0; i < m_current_value; i++) {
			m_spinners.add(new JSpinner());
			m_spinners.get(i).setEnabled(false);
			m_parent.add(m_spinners.get(i));
		}
		m_parent.validate();
		m_grandparent.add(m_parent, m_position);
		m_grandparent.validate();
		SpringUtilities.makeCompactGrid(m_grandparent,
				m_grandparent.getRows(), m_grandparent.getCols(), 3, 3, 
				3, 3);
		m_grandparent.revalidate();
	}

	public int getValue() {
		return m_current_value;
	}

	public Vector<JSpinner> getSpinners() {
		return m_spinners;
	}

	private int m_current_value;
	private Vector<JSpinner> m_spinners;
	private RowsCountingPanel m_grandparent;
	private JPanel m_parent;
	private int m_position;
}