package com.flightpanels.scs;

import javax.swing.JSpinner;

public class UpdateableBoolSpinner implements IUpdateable<Boolean> {

	public UpdateableBoolSpinner(JSpinner spinner) {
		m_spinner = spinner;
		m_current_value = false;
	}
	
	public void update(Boolean value) {
		m_current_value = value;
		float f = (value.booleanValue() ? 1 : 0);
		m_spinner.setValue(f);
	}

	public boolean getValue() {
		return m_current_value;
	}

	private JSpinner m_spinner;
	private boolean m_current_value;
}
