package com.flightpanels.scs;

import javax.swing.JSpinner;
import java.util.ArrayList;

public class UpdateableChar4Spinners implements IUpdateable<ArrayList<Short>> {

	public UpdateableChar4Spinners(JSpinner[] spinners) {
		m_spinner = spinners;
		m_current_value = new ArrayList<Short>();
	}

	public void update(ArrayList<Short> value) {
		m_current_value = value;
		for (int i = 0; i < 4; ++i) {
			float f = value.get(i);
			m_spinner[i].setValue(f);
		}
	}

	public ArrayList<Short> getValue() {
		return m_current_value;
	}

	private JSpinner[] m_spinner;
	private ArrayList<Short> m_current_value;

}
