package com.flightpanels.scs;

import javax.swing.JSpinner;

public class UpdateableFloatSpinner implements IUpdateable<Float> {

	public UpdateableFloatSpinner(JSpinner spinner) {
		m_spinner = spinner;
		m_current_value = 0.0f;
		m_scale = 1;
		m_offset = 0;
	}

	public UpdateableFloatSpinner(JSpinner spinner, float scale) {
		m_spinner = spinner;
		m_current_value = 0.0f;
		m_scale = scale;
		m_offset = 0;
	}

	public UpdateableFloatSpinner(JSpinner spinner, float scale, float offset) {
		m_spinner = spinner;
		m_current_value = 0.0f;
		m_scale = scale;
		m_offset = offset;
	}

	public void update(Float value) {
		m_current_value = value * m_scale + m_offset;
		m_spinner.setValue(value * m_scale + m_offset);
	}

	public float getValue() {
		return m_current_value;
	}

	private JSpinner m_spinner;
	private float m_current_value;
	private float m_scale;
	private float m_offset;
}