package com.flightpanels.scs;

import java.util.Vector;

public class UpdateableFloatVectorSpinners implements
IUpdateable<Vector<Float>> {

	public UpdateableFloatVectorSpinners(ResizeableSpinnersPanel panel) {
		m_current_value = new Vector<Float>();
		m_panel = panel;
	}

	public void update(Vector<Float> value) {
		m_current_value = value;
		for (int i = 0 ; i < m_panel.getValue() ; i++) {
			float f = value.get(i).floatValue();
			m_panel.getSpinners().get(i).setValue(f);
		}
	}

	public Vector<Float> getValue() {
		return m_current_value;
	}

	private Vector<Float> m_current_value;
	private ResizeableSpinnersPanel m_panel;
}