package com.flightpanels.scs;

import javax.swing.JSpinner;

public class UpdateableIntSpinner implements IUpdateable<Integer> {

	public UpdateableIntSpinner(JSpinner spinner) {
		m_spinner = spinner;
		m_current_value = 0;
		m_scale = 1;
		m_offset = 0;
	}
	
	public UpdateableIntSpinner(JSpinner spinner, float scale) {
		m_spinner = spinner;
		m_current_value = 0;
		m_scale = scale;
		m_offset = 0;
	}
	
	public UpdateableIntSpinner(JSpinner spinner, boolean com) {
		m_spinner = spinner;
		m_current_value = 0;
		m_scale = 1;
		m_offset = 0;
		m_is_com = com;
	}
	
	public UpdateableIntSpinner(JSpinner spinner, float scale, float offset) {
		m_spinner = spinner;
		m_current_value = 0;
		m_scale = scale;
		m_offset = offset;
	}

	public void update(Integer value) {
		if (m_is_com && (value % 100 == 20 || value % 100 == 70))
			value += 5;
		m_current_value = (int)Math.round(value * m_scale + m_offset);
		m_spinner.setValue(value * m_scale + m_offset);
	}

	public int getValue() {
		return m_current_value;
	}

	private JSpinner m_spinner;
	private int m_current_value;
	private float m_scale;
	private float m_offset;
	private boolean m_is_com=false;
}