# -*- coding: utf-8 -*-

# the threading library of python will easily execute the Receiver.run() function in background
import threading

# by importing all of libcanaero, we also get all the ID shortcuts
from libcanaero import *

# I will use this to quit the program by entering a non-integer value
def isint(value):
  try:
    int(value)
    return True
  except:
    return False

# This is an example of how you can execute the Receiver.run() function in a separate thread
class AsyncReceiverRun(threading.Thread):
  def __init__(self, receiver):
    threading.Thread.__init__(self)
    self.recv = receiver
    self.continue_to_run = True
  def run(self):
    while self.continue_to_run:
      recv.run()
  def stop(self):
    self.continue_to_run = False

# the minimum revision of the SCS identifier distribution this program needs
revision_required = 1

# create a receiver and announce ourselves to the bus
recv = Receiver(revision_required)

# this is the callback for the COM frequency. COM freqs are transmitted in kHz
def comfreq( freq ):
  print "COM 1 freq is now %f\n" % (freq/1000.0)

# this is the callback for the landing lights switch
def landlight ( on ):
  if on:
    print "landing lights on"
  else:
    print "landing lights off"

# this callback will print the EGT values of the engines.
# EGT is transmitted in degrees Kelvin.
def egt ( egt_array ):
  print "# | deg Celsius"
  i = 1
  for egt_val in egt_array:
    print "%(engine)d | %(value)f" %{'engine': (i), 'value': (egt_val - 273.2)}
    i+=1
  print "\n"

# request the COM1 freq and bind it to the callback
# note that this freq is transmitted as in integer, hence the I function
recv.requestDataI(COM1_FREQ_KHZ.Id(), comfreq)

# do the same for the landing light
# note that the switch is transmitted as a bool, hence the B function
recv.requestDataB(LIGHT_LANDING_SWITCH.Id(), landlight)

# and finally, the EGT values
# note that the engine values are transmitted as a vector of floats, hence the VF function
recv.requestDataVF(ENG_EGT_K.Id(), egt)

# start the receiver in background
background = AsyncReceiverRun(recv)
background.start()

while True:
  entered = input("Please enter a new com frequency or a non-number to quit\n")
  if isint(entered):
    # send the new com freq as integer.
    recv.sendDataI(COM1_FREQ_KHZ.Id(), int(entered))
  else:
    break

# turn on the landing lights before we quit ;)
# note the use of the B function for switches
recv.sendDataB(LIGHT_LANDING_SWITCH.Id(), True)

background.stop()
background.join()
 